<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method. Please use POST."]);
    exit;
}

// ✅ Access key validation
$headers = getallheaders();
$providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);
$valid_access_key = "qwerty403"; // Replace with your actual key

if (!$providedKey || $providedKey !== $valid_access_key) {
    echo json_encode(["status" => "error", "message" => "Unauthorized access"]);
    exit;
}

try {
    // ✅ Connect to MongoDB
    $client = new MongoDB\Client("mongodb://localhost:27017");
    $collection = $client->clicktrackerbkps->emp_data;

    // ✅ Prepare 10 records (3 with specific IP)
    $records = [];
    $departments = ["HR", "Finance", "Marketing", "Sales", "Support", "Operations", "IT", "Admin"];
    $countries = ["India", "USA", "UK", "Germany", "Australia", "Canada", "France"];
    $browsers = ["Chrome", "Firefox", "Edge", "Safari", "Opera"];

    // 3 records with fixed IP
    for ($i = 1; $i <= 3; $i++) {
        $records[] = [
            "employee_id"  => "EMP" . str_pad($i, 4, '0', STR_PAD_LEFT),
            "name"         => "Employee $i",
            "email"        => "employee$i@example.com",
            "department"   => "Engineering",
            "designation"  => "Software Developer",
            "salary"       => rand(60000, 120000),
            "joining_date" => new MongoDB\BSON\UTCDateTime(strtotime("2024-01-01 +$i days") * 1000),
            "status"       => "Active",
            "ip_address"   => "129.151.162.2",
            "country"      => "India",
            "browser"      => "Chrome",
            "referrer"     => "https://example.com",
            "created_at"   => new MongoDB\BSON\UTCDateTime()
        ];
    }

    // 7 more records with random IPs and departments
    for ($i = 4; $i <= 10; $i++) {
        $records[] = [
            "employee_id"  => "EMP" . str_pad($i, 4, '0', STR_PAD_LEFT),
            "name"         => "Employee $i",
            "email"        => "employee$i@example.com",
            "department"   => $departments[array_rand($departments)],
            "designation"  => "Staff Member",
            "salary"       => rand(40000, 110000),
            "joining_date" => new MongoDB\BSON\UTCDateTime(strtotime("2024-01-01 +$i days") * 1000),
            "status"       => "Active",
            "ip_address"   => "192.168." . rand(1, 255) . "." . rand(1, 255),
            "country"      => $countries[array_rand($countries)],
            "browser"      => $browsers[array_rand($browsers)],
            "referrer"     => "https://site" . rand(1, 10) . ".example.com",
            "created_at"   => new MongoDB\BSON\UTCDateTime()
        ];
    }

    // ✅ Insert all records
    $insertResult = $collection->insertMany($records);

    echo json_encode([
        "status" => "success",
        "inserted_count" => $insertResult->getInsertedCount(),
        "message" => "Inserted 10 dummy employee records successfully!"
    ]);

} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
