<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Please use POST."
    ]);
    exit;
}

// ✅ Access key validation
$headers = getallheaders();
$providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);

$valid_access_key = "qwerty403"; // 🔑 replace with your real key

if (!$providedKey || $providedKey !== $valid_access_key) {
    echo json_encode([
        "status" => "error",
        "message" => "You are not allowed to access this page"
    ]);
    exit;
}

// ✅ Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// Fetch all documents
$cursor = $collection->find([], [
    'sort' => ['_id' => -1], // latest first
]);

// Convert cursor to array
$data = iterator_to_array($cursor);

// Format response
$response = [];
foreach ($data as $doc) {
    $response[] = [
        "id"              => (string) $doc->_id,
        "rotator_id"      => $doc->rotator_id ?? '',
        "link_id"         => $doc->link_id ?? '',
        "link"            => $doc->link ?? '',
        "redirect_url"    => $doc->redirect_url ?? '',
        "rotator_mode"    => $doc->rotator_mode ?? '',
        "user_id"         => $doc->user_id ?? '',
        "status"          => $doc->status ?? '',
        "hit_time"        => isset($doc->hit_time) ? $doc->hit_time->toDateTime()->format('Y-m-d H:i:s') : '',
        "fake_click_status"=> $doc->fake_click_status ?? '',
        "split_level1"    => $doc->split_level1 ?? '',
        "split_level2"    => $doc->split_level2 ?? '',
        "split_level3"    => $doc->split_level3 ?? '',
        "split_level4"    => $doc->split_level4 ?? '',
        "split_level5"    => $doc->split_level5 ?? '',
        "latitude"        => $doc->latitude ?? '',
        "longitude"       => $doc->longitude ?? '',
        "browserName"     => $doc->browserName ?? '',
        "deviceType"      => $doc->deviceType ?? '',
        "os"              => $doc->os ?? '',
        "platform"        => $doc->platform ?? '',
        "userAgent"       => $doc->userAgent ?? '',
        "city"            => $doc->city ?? '',
        "country"         => $doc->country ?? '',
        "ip"              => $doc->ip ?? '',
        "region"          => $doc->region ?? '',
        "created_at"      => isset($doc->created_at) ? $doc->created_at->toDateTime()->format('Y-m-d H:i:s') : '',
    ];
}

// ✅ Return JSON
echo json_encode([
    "status" => "success",
    "count"  => count($response),
    "data"   => $response
], JSON_PRETTY_PRINT);
