<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Please use POST."
    ]);
    exit;
}

// ✅ Access key validation
$headers = getallheaders();
$providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);

$valid_access_key = "qwerty403"; // 🔑 replace with your actual key

if (!$providedKey || $providedKey !== $valid_access_key) {
    echo json_encode([
        "status" => "error",
        "message" => "You are not allowed to access this page"
    ]);
    exit;
}

// ✅ Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// Collect request data (POST body)
$data = [
    "rotator_id"       => $_POST['rotator_id'] ?? null,
    "link_id"          => $_POST['link_id'] ?? null,
    "link"             => $_POST['link'] ?? '',
    "redirect_url"     => $_POST['redirect_url'] ?? '',
    "rotator_mode"     => $_POST['rotator_mode'] ?? '',
    "user_id"          => $_POST['user_id'] ?? '',
    "status"           => $_POST['status'] ?? 0,
    "hit_time"         => new MongoDB\BSON\UTCDateTime(), // Auto timestamp
    "fake_click_status"=> $_POST['fake_click_status'] ?? 0,
    "split_level1"     => $_POST['split_level1'] ?? '',
    "split_level2"     => $_POST['split_level2'] ?? '',
    "split_level3"     => $_POST['split_level3'] ?? '',
    "split_level4"     => $_POST['split_level4'] ?? '',
    "split_level5"     => $_POST['split_level5'] ?? '',
    "latitude"         => $_POST['latitude'] ?? '',
    "longitude"        => $_POST['longitude'] ?? '',
    "browserName"      => $_POST['browserName'] ?? '',
    "deviceType"       => $_POST['deviceType'] ?? '',
    "os"               => $_POST['os'] ?? '',
    "platform"         => $_POST['platform'] ?? '',
    "userAgent"        => $_POST['userAgent'] ?? '',
    "city"             => $_POST['city'] ?? '',
    "country"          => $_POST['country'] ?? '',
    "ip"               => $_POST['ip'] ?? '',
    "region"           => $_POST['region'] ?? '',
    "created_at"       => new MongoDB\BSON\UTCDateTime()
];

// ✅ Insert into MongoDB
try {
    $insertResult = $collection->insertOne($data);

    if ($insertResult->getInsertedCount() > 0) {
        echo json_encode([
            "status" => "success",
            "id"     => (string) $insertResult->getInsertedId(),
            "data"   => $data
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Insert failed"]);
    }
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
