<?php
require '../vendor/autoload.php';

header("Content-Type: application/json");

// ✅ Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Please use POST."
    ]);
    exit;
}

// ✅ Access key validation
$valid_access_key = "qwerty403"; // <-- change this to your actual key

if (!isset($_POST['access_key']) || $_POST['access_key'] !== $valid_access_key) {
    echo json_encode([
        "status" => "error",
        "message" => "You are not allowed to access this page"
    ]);
    exit;
}

// ✅ Check if ID is passed
if (!isset($_POST['id'])) {
    echo json_encode([
        "status" => "error",
        "message" => "ID parameter is required"
    ]);
    exit;
}

$id = $_POST['id'];

$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

try {
    $objectId = new MongoDB\BSON\ObjectId($id); // Convert string to ObjectId
    $data = $collection->findOne(['_id' => $objectId]);

    if ($data) {
        echo json_encode([
            "status" => "success",
            "data" => $data
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No user found with ID $id"
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
