<?php
header("Content-Type: application/json");
require '../vendor/autoload.php'; // MongoDB PHP library

use MongoDB\Client;
use MongoDB\BSON\ObjectId;
use MongoDB\BSON\UTCDateTime;

// ✅ Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Please use POST."
    ]);
    exit;
}

// ✅ Access key validation
$valid_access_key = "qwerty403"; // <-- change this to your actual key
if (!isset($_POST['access_key']) || $_POST['access_key'] !== $valid_access_key) {
    echo json_encode([
        "status" => "error",
        "message" => "You are not allowed to access this page"
    ]);
    exit;
}

// ✅ Check if we got an ID to update
if (empty($_POST['id'])) {
    echo json_encode(["status" => "error", "message" => "ID is required for update"]);
    exit;
}

$id = $_POST['id']; // _id of document
$updateData = [];

// Collect fields to update (only update if provided)
$fields = [
    "rotator_id", "link_id", "link", "redirect_url", "rotator_mode",
    "user_id", "status", "fake_click_status",
    "split_level1", "split_level2", "split_level3", "split_level4", "split_level5",
    "latitude", "longitude", "browserName", "deviceType", "os", "platform",
    "userAgent", "city", "country", "ip", "region"
];

foreach ($fields as $field) {
    if (isset($_POST[$field])) {
        $updateData[$field] = $_POST[$field];
    }
}

// Always update timestamp
$updateData["updated_at"] = new UTCDateTime();

try {
    $client = new Client("mongodb://localhost:27017");
    $collection = $client->clicktracker->wp_rotator_link_hit_logs;

    $result = $collection->updateOne(
        ["_id" => new ObjectId($id)],   // match document by _id
        ['$set' => $updateData]         // update only given fields
    );

    if ($result->getModifiedCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Document updated"]);
    } else {
        echo json_encode(["status" => "error", "message" => "No document updated (check ID or fields)"]);
    }
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
