<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Restrict to POST only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method. Please use POST."]);
    exit;
}

// ✅ Access key validation
$headers = getallheaders();
// $providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);
// $valid_access_key = "qwerty403"; // Replace with your actual key

// if (!$providedKey || $providedKey !== $valid_access_key) {
//     echo json_encode(["status" => "error", "message" => "Unauthorized access"]);
//     exit;
// }

// ✅ Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

try {
    // ✅ Delete all records where department is Engineering
    $deleteResult = $collection->deleteMany(['ip' => '129.151.162.2']);

    echo json_encode([
        "status" => "success",
        "deleted_count" => $deleteResult->getDeletedCount(),
        "message" => "Log of ip 129.151.162.2 is deleted succussfully."
    ]);

} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
