<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

$client     = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Access Key Validation ---
$access_key = $_POST['access_key'] ?? '';
if ($access_key !== 'qwerty403') {
    echo json_encode(["status" => "error", "message" => "Invalid access key"]);
    exit;
}

// --- Optional Date Filter ---
$date = $_GET['date'] ?? '';  // format: DD-MM-YYYY

$dateFilter = [];
if (!empty($date)) {
    $timestamp = DateTime::createFromFormat('d-m-Y', $date);
    if ($timestamp) {
        $start = new MongoDB\BSON\UTCDateTime($timestamp->setTime(0, 0, 0)->getTimestamp() * 1000);
        $end   = new MongoDB\BSON\UTCDateTime($timestamp->setTime(23, 59, 59)->getTimestamp() * 1000);

        $dateFilter = [
            'created_at' => [
                '$gte' => $start,
                '$lte' => $end
            ]
        ];
    }
}

// --- Get link IDs (POST or auto-fetch if missing) ---
$link_ids = $_POST['link_id'] ?? '';

if (empty($link_ids)) {
    // Auto fetch all link_ids from DB
    $cursor = $collection->distinct("link_id", $dateFilter);
    $link_ids = $cursor ?: [];
} else {
    $link_ids = array_map('trim', explode(',', $link_ids));
}

// Convert to array if still empty
if (!is_array($link_ids)) {
    $link_ids = [$link_ids];
}

// --- Unique IP Count ---
$cursor = $collection->find(
    array_merge(
        ['link_id' => ['$in' => $link_ids]],
        $dateFilter
    ),
    ['projection' => ['_id' => 0, 'ip' => 1]]
);

$unique_ips = [];
foreach ($cursor as $doc) {
    if (!empty($doc['ip'])) {
        $unique_ips[$doc['ip']] = true;
    }
}

$total_ips_count = count($unique_ips);

// --- Aggregation Query ---
$pipeline = [
    ['$match' => array_merge(
        ['link_id' => ['$in' => $link_ids]],
        $dateFilter
    )],

    ['$group' => [
        '_id' => '$link_id',
        'TC'  => ['$sum' => 1],
        'UC_IPS' => ['$sum' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "0"]], 1, 0
            ]
        ]],
        'FC'  => ['$sum' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "1"]], 1, 0
            ]
        ]]
    ]]
];

$cursor = $collection->aggregate($pipeline);

// --- Collect results ---
$temp = [];
foreach ($cursor as $row) {
    $temp[$row->_id] = [
        "TC" => $row->TC,
        "UC" => $total_ips_count,
        "FC" => $row->FC,
    ];
}

// --- Output for all links ---
$output = [];
foreach ($link_ids as $id) {
    $output[$id] = $temp[$id] ?? [
        "TC" => 0,
        "UC" => $total_ips_count,
        "FC" => 0
    ];
}

// --- Final Output ---
echo json_encode([
    "status" => "success",
    "date"   => $date ?: "all",
    "data"   => $output
], JSON_PRETTY_PRINT);
