<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// âœ… Restrict to POST method only
// if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
//     echo json_encode([
//         "status" => "error",
//         "message" => "Invalid request method. Please use POST."
//     ]);
//     exit;
// }

// // âœ… Access key validation
// $headers = getallheaders();
// $providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);

// $valid_access_key = "qwerty403"; // ðŸ”‘ replace with your real key

// if (!$providedKey || $providedKey !== $valid_access_key) {
//     echo json_encode([
//         "status" => "error",
//         "message" => "You are not allowed to access this page"
//     ]);
//     exit;
// }


// $client = new MongoDB\Client("mongodb://localhost:27017");
// $collection = $client->clicktracker->wp_rotator_link_hit_logs;

// $count = $collection->countDocuments();

// $oneDocument = $collection->findOne([], ['projection' => ['_id' => 0]]);

// // Return JSON
// header('Content-Type: application/json');
// echo json_encode([
//     "status" => "success",
//     "count"  => $count,
//     "sample_entry" => $oneDocument
// ], JSON_PRETTY_PRINT);



// $client = new MongoDB\Client("mongodb://localhost:27017");
// $collection = $client->clicktracker->wp_rotator_link_hit_logs;

// // Fetch all documents with link_id = "2395"
// $cursor = $collection->find(
//     ['link_id' => '2395'], // use integer 2395 if stored as number
//     ['projection' => ['_id' => 0]] // exclude Mongo _id field (optional)
// );

// // Convert cursor to array
// $records = iterator_to_array($cursor, false);

// // Return JSON
// header('Content-Type: application/json');
// echo json_encode([
//     "status" => "success",
//     "link_id" => 2395,
//     "count" => count($records),
//     "data" => $records
// ], JSON_PRETTY_PRINT);










// ✅ Fetch optional query parameters
$rotator_id = $_GET['rotator_id'] ?? $_POST['rotator_id'] ?? null;
$link_id    = $_GET['link_id'] ?? $_POST['link_id'] ?? null;
$dateStr    = $_GET['date'] ?? $_POST['date'] ?? ''; // format: dd/mm/yyyy

// ✅ Default date = today if not provided
if (empty($dateStr)) {
    $dateStr = date('d/m/Y');
}

// ✅ Parse date
$dateParts = explode('/', $dateStr);
if (count($dateParts) !== 3) {
    echo json_encode(["status" => "error", "message" => "Invalid date format. Use dd/mm/yyyy"]);
    exit;
}
list($day, $month, $year) = $dateParts;

// ✅ Calculate start and end timestamps for that day
$startOfDay = strtotime("$year-$month-$day 00:00:00") * 1000;
$endOfDay   = strtotime("$year-$month-$day 23:59:59") * 1000;

// ✅ Convert to MongoDB UTCDateTime objects
$startDate = new MongoDB\BSON\UTCDateTime($startOfDay);
$endDate   = new MongoDB\BSON\UTCDateTime($endOfDay);

// ✅ Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// ✅ Build dynamic query
$query = [
    'hit_time' => [
        '$gte' => $startDate,
        '$lte' => $endDate
    ]
];

if (!empty($rotator_id)) {
    $query['rotator_id'] = (string)$rotator_id;
}
if (!empty($link_id)) {
    $query['link_id'] = (string)$link_id;
}

// ✅ Fetch records
$cursor = $collection->find($query, ['projection' => ['_id' => 0]]);
$records = iterator_to_array($cursor, false);

// ✅ Prepare analytics
$totalRecords = count($records);
$uniqueIps = [];
$recordsWithRegion = 0;
$recordsWithoutRegion = 0;
$allIps = [];

foreach ($records as $doc) {
    if (!empty($doc['ip'])) {
        $uniqueIps[$doc['ip']] = true;
        $allIps[] = $doc['ip'];
    }
    if (!empty($doc['region'])) {
        $recordsWithRegion++;
    } else {
        $recordsWithoutRegion++;
    }
}

// ✅ Build response
$response = [
    "status" => "success",
    "filters" => [
        "rotator_id" => $rotator_id ?? "all",
        "link_id" => $link_id ?? "all",
        "date" => "$day/$month/$year"
    ],
    "summary" => [
        "total_records" => $totalRecords,
        "unique_ip_count" => count($uniqueIps),
        "total_ip_count" => count($allIps),
        "records_with_region" => $recordsWithRegion,
        "records_without_region" => $recordsWithoutRegion
    ],
    "data" => $records
];

echo json_encode($response, JSON_PRETTY_PRINT);
