<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Connect to MongoDB
try {
    $client = new MongoDB\Client("mongodb://localhost:27017");
    $collection = $client->clicktracker->wp_rotator_link_hit_logs;

    // ✅ Total document count
    $totalCount = $collection->countDocuments();

    // ✅ Count documents for specific IP
    $targetIp = "129.151.162.2";
    $ipCount = $collection->countDocuments(['ip' => $targetIp]);

    // ✅ Get one sample entry (excluding _id)
    // $sampleEntry = $collection->findOne([], ['projection' => ['_id' => 0]]);

    // ✅ JSON response
    echo json_encode([
        "status" => "success",
        "summary" => [
            "total_records" => $totalCount,
            "ip" => $targetIp,
            "ip_count" => $ipCount
        ],
        // "sample_entry" => $sampleEntry
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
