<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// âœ… Restrict to POST method only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Please use POST."
    ]);
    exit;
}

// âœ… Access key validation
$headers = getallheaders();
$providedKey = $_POST['access_key'] ?? ($headers['access_key'] ?? null);

$valid_access_key = "qwerty403"; // ðŸ”‘ replace with your real key

if (!$providedKey || $providedKey !== $valid_access_key) {
    echo json_encode([
        "status" => "error",
        "message" => "You are not allowed to access this page"
    ]);
    exit;
}

$rotator_id = !empty($_POST['rotator_id']) ? (int) $_POST['rotator_id'] : null;
$user_ip    = !empty($_POST['user_ip']) ? $_POST['user_ip'] : null;

// âœ… Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

$filter = [
    'rotator_id' => (string) $rotator_id, // match stored type
    'ip'         => $user_ip,
    'status'     => 0
];

// Count documents instead of fetching them
$user_ip_count = $collection->countDocuments($filter);

echo json_encode([
    "status" => "success",
    "userip_count"  => $user_ip_count,
    //"debug_filter"  => $filter  
], JSON_PRETTY_PRINT);

