<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

$client     = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Access Key Validation ---
$access_key = $_POST['access_key'] ?? '';
if ($access_key !== 'qwerty403') {
    echo json_encode(["status" => "error", "message" => "Invalid access key"]);
    exit;
}

// --- Link IDs from request ---
$link_ids = $_POST['link_id'] ?? '';
if (empty($link_ids)) {
    echo json_encode(["status" => "error", "message" => "Missing link_id"]);
    exit;
}
$link_ids = array_map('trim', explode(',', $link_ids));
 //print_r($link_ids); die;

// âœ… Connect to MongoDB
$client = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Single Aggregation Query ---
$pipeline = [
    ['$match' => ['link_id' => ['$in' => $link_ids]]],

    ['$group' => [
        '_id' => '$link_id',
        'TC'  => ['$sum' => 1], // total clicks
        'UC_IPS' => ['$addToSet' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "0"]],
                '$ip',
                null
            ]
        ]],
        'FC'  => ['$sum' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "1"]],
                1,
                0
            ]
        ]]
    ]]
];

$cursor = $collection->aggregate($pipeline);

// --- Collect results into map ---
$temp = [];
foreach ($cursor as $row) {
    $uc_ips = array_filter($row['UC_IPS']->getArrayCopy(), fn($ip) => $ip !== null);
    $temp[$row->_id] = [
        "TC" => $row->TC,
        "UC" => count($uc_ips),
        "FC" => $row->FC,
    ];
}

// --- Reorder according to input order ---
$output = [];
foreach ($link_ids as $id) {
    $output[$id] = $temp[$id] ?? ["TC" => 0, "UC" => 0, "FC" => 0];
}

// --- Final Output ---
echo json_encode([
    "status" => "success",
    "data"   => $output
], JSON_PRETTY_PRINT);