<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

$client     = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Access Key Validation ---
// $access_key = $_POST['access_key'] ?? '';
// if ($access_key !== 'qwerty403') {
//     echo json_encode(["status" => "error", "message" => "Invalid access key"]);
//     exit;
// }

// --- Optional Date Filter ---
$date = $_GET['date'] ?? '';  // format: DD-MM-YYYY

$dateFilter = [];
if (!empty($date)) {
    $timestamp = DateTime::createFromFormat('d-m-Y', $date);
    if ($timestamp) {
        $start = new MongoDB\BSON\UTCDateTime($timestamp->setTime(0, 0, 0)->getTimestamp() * 1000);
        $end   = new MongoDB\BSON\UTCDateTime($timestamp->setTime(23, 59, 59)->getTimestamp() * 1000);

        $dateFilter = [
            'created_at' => [
                '$gte' => $start,
                '$lte' => $end
            ]
        ];
    }
}

// --- Optional link_id filter ---
$link_ids = $_POST['link_id'] ?? '';

$query = $dateFilter;

if (!empty($link_ids)) {
    $link_ids = array_map('trim', explode(',', $link_ids));
    $query['link_id'] = ['$in' => $link_ids];
}

// --- Fetch ALL data for this date ---
$cursor = $collection->find(
    $query,
    ['projection' => ['_id' => 0]]    // remove MongoDB internal ID
);

$records = [];
foreach ($cursor as $doc) {
    $records[] = $doc;
}

// --- Final Output ---
echo json_encode([
    "status" => "success",
    "total_records" => count($records),
    "date"   => $date ?: "all"
], JSON_PRETTY_PRINT);
