<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

// ✅ Connect to MongoDB once
$client     = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Access Key Validation ---
$access_key = $_POST['access_key'] ?? '';
if ($access_key !== 'qwerty403') {
    echo json_encode(["status" => "error", "message" => "Invalid access key"]);
    exit;
}

// --- Rotator IDs from request ---
$rotator_ids = $_POST['rotator_id'] ?? '';
if (empty($rotator_ids)) {
    echo json_encode(["status" => "error", "message" => "Missing rotator_id"]);
    exit;
}
$rotator_ids = array_map('trim', explode(',', $rotator_ids));

// --- Single Aggregation Query ---
$pipeline = [
    ['$match' => ['rotator_id' => ['$in' => $rotator_ids]]],
    ['$group' => [
        '_id' => '$rotator_id',
        'TC'  => ['$sum' => 1],
        'UC'  => ['$addToSet' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "0"]],
                '$ip',
                null
            ]
        ]],
        'FC'  => ['$sum' => [
            '$cond' => [
                ['$eq' => ['$fake_click_status', "1"]],
                1,
                0
            ]
        ]]
    ]],
    // ✅ Count unique IPs directly
    ['$project' => [
        'TC' => 1,
        'FC' => 1,
        'UC' => [
            '$size' => [
                '$setDifference' => ['$UC', [null]] // remove null before counting
            ]
        ]
    ]]
];

$cursor = $collection->aggregate($pipeline);

// --- Collect results into map ---
$temp = [];
foreach ($cursor as $row) {
    $temp[$row->_id] = [
        "TC" => $row->TC,
        "UC" => $row->UC,
        "FC" => $row->FC,
    ];
}

// --- Reorder according to input order ---
$output = [];
foreach ($rotator_ids as $id) {
    $output[$id] = $temp[$id] ?? ["TC" => 0, "UC" => 0, "FC" => 0];
}

// --- Final Output ---
echo json_encode([
    "status" => "success",
    "data"   => $output
], JSON_PRETTY_PRINT);
