<?php
require '../vendor/autoload.php'; // MongoDB PHP library

header("Content-Type: application/json");

$client     = new MongoDB\Client("mongodb://localhost:27017");
$collection = $client->clicktracker->wp_rotator_link_hit_logs;

// --- Access Key Validation ---
$access_key = $_POST['access_key'] ?? '';
if ($access_key !== 'qwerty403') {
    echo json_encode(["status" => "error", "message" => "Invalid access key"]);
    exit;
}

$rotator_id = $_POST['rotator_id'] ?? '';
/*if (empty($rotator_id)) {
    echo json_encode(["status" => "error", "message" => "Missing rotator_id"]);
    exit;
}*/
$user_id = $_POST['user_id'] ?? '';
/*if (empty($user_id)) {
    echo json_encode(["status" => "error", "message" => "Missing user_id"]);
    exit;
}*/

if (empty($rotator_id) && empty($user_id)) {
    $filter = [];
} else {
    $filter = [
        'rotator_id' => $rotator_id,
        'user_id'    => $user_id
    ];
}
$update = ['$set' => ['status' => 1]];

$result = $collection->updateMany($filter, $update);

// --- Response ---
echo json_encode([
    "status"  => "success",
    "matched" => $result->getMatchedCount(),
    "updated" => $result->getModifiedCount()
], JSON_PRETTY_PRINT);